#!/bin/sh

case $0 in
        /*) rootdir=$(cd "$(dirname $0)"; pwd); ;;
        *)  rootdir=$(cd "$(dirname $(pwd)/$0)"; pwd); ;;
esac

esxi_H="${1}"
esxi_U="${2}"
esxi_P="${3}"
sb_U="${4}"
sb_P="${5}"
sb_vmpath="${6}"
sb_ip="${7}"
sb_default_ip="${8}"
os_start_time="${9}"

setup_logfile="${rootdir}/setup.log"
setup_logcount=10
setup_logsize=10;	#in meta bytes

setup_message ()
{
    log_date=$(date '+%Y/%m/%d %H:%M:%S');

    if [ $# -eq 0 ]; then
        awk "{ printf(\"%s - %s\\n\", strftime(\"%Y/%m/%d %H:%M:%S\"), \$0) >> \"${setup_logfile}\"; }"
    else
        echo "${log_date} - $*" >> ${setup_logfile}
    fi
}

setup_gettext ()
{
    gettext "Setup" "$1"
}

setup_printf ()
{
    printf "$@";
}

setup_rotate_log ()
{
    logfile=$1;
    count=$2;

    ndx=$(( ${count} - 1 ))

    rm -f "${logfile}.${ndx}";

    while [ ${ndx} -ge 1 ]; do
        mv -f "${logfile}.$(( ${ndx} - 1 ))" "${logfile}.${ndx}";
        ndx=$(( ${ndx} - 1 ));
    done

    mv -f "${logfile}" "${logfile}.${ndx}";
    touch "${logfile}";
}

setup_check_logs ()
{
    logsize=$(ls -1 "${setup_logfile}" | awk '{printf("%d", $5 / 1024 / 1024);}');
    if [ ${logsize} -ge ${setup_logsize} ]; then
        setup_rotate_log "${setup_logfile}" ${setup_logcount};
    fi
}

setup_ping ()
{
    ipaddr=$1;
    ping -c 1 ${ipaddr} 2>&1 >/dev/null
    return $?;
}

sandbox_clone () {
    vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sb_vmpath}" start 2>&1 | setup_message;
    
    local name=`basename "${sb_vmpath}" | sed 's/.vmx//'`
    cnt=${os_start_time}
    while [ ${cnt} -ge 1 ]; do
        # Check if OS is up
        if setup_ping ${sb_default_ip}; then
            setup_message "${name} OS is up!!"
            break
        fi
        cnt=$(( ${cnt} - 1 ))
        sleep 1
    done

    # Wait for samba service up
    sleep 30

    sed -i \
        -e "s,^\\(.*\\<sandbox_ip\\>[^=]*=\\s*\\).*\$,\\1\"${sb_ip}\"," \
        "${rootdir}/ip.txt"

    # create sandcaslte src log folder
    [ ! -e ${rootdir}/c_dir ]  && mkdir ${rootdir}/c_dir

    # connnect shared folder for 5 times
    setup_message "mount -t cifs -o username=<hidden>,password=<hidden> //${sb_default_ip}/c$ ${rootdir}/c_dir";
    if mount -t cifs -o username=${sb_U},password=${sb_P} //${sb_default_ip}/c$ ${rootdir}/c_dir 2>&1 >/dev/null; then
        setup_message "${name} Mount Success!!";
        if [ "${sb_ip}" != "1.1.2.1" ]; then
            cp  "${rootdir}/ip.txt" "${rootdir}/c_dir" 2>&1 | setup_message;
        fi
        
        umount "${rootdir}/c_dir" 2>&1 | setup_message;
        setup_message "${name} Umount Success!!";
     
        retry_count=3
        while [ "${retry_count}" -ge 1 ];
        do
            if [ "${sb_ip}" != "1.1.2.1" ]; then
                setup_message "${sb_vmpath} Reinsert CD!!";
                vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sb_vmpath}" disconnectdevice "CD/DVD drive 1" 2>&1 | setup_message;
                sleep 2	# take a rest to avoid timing issue
                vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sb_vmpath}" connectdevice "CD/DVD drive 1" 2>&1 | setup_message;
            fi
            
            cnt=30;
            while [ ${cnt} -ge 1 ]; do
                # Check if ip is reset
                if setup_ping "${sb_ip}"; then
                    setup_message "${name} ip is reset to ${sb_ip}!!";
                    break;
                fi
                cnt=$(( ${cnt} - 1 ));
                sleep 1;
            done
            
            if [ "${cnt}" -ge 1 ]; then
                break
            elif [ "${retry_count}" -eq 1 ]; then
                exit 1
            fi
            
            retry_count=$((${retry_count}-1))
        done

        setup_message "${name} Eject CD!!";
        vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sb_vmpath}" disconnectdevice "CD/DVD drive 1" 2>&1 | setup_message;

        vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sb_vmpath}" createsnapshot init "${sb_ip}" 1 1 2>&1 | setup_message;
        vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sb_vmpath}" stop hard 2>&1 | setup_message;
    else
        setup_message "${name} Counldn't Mount!!";
        vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sb_vmpath}" stop hard 2>&1 | setup_message;
        setup_message "setup_sandbox exit with 1 !!";
        exit 1;
    fi
}

setup_check_logs;
sandbox_clone;
setup_message "setup_sandbox exit with 0 !!";
exit 0;
